//
//  Handling_Location_Changes_in_the_BackgroundAppDelegate.m
//  Handling Location Changes in the Background
//
//  Created by Vandad Nahavandipoor on 20/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Handling_Location_Changes_in_the_BackgroundAppDelegate.h"

@implementation Handling_Location_Changes_in_the_BackgroundAppDelegate

@synthesize window = _window;
@synthesize myLocationManager;
@synthesize executingInBackground;

- (BOOL) isExecutingInBackground{
  return executingInBackground;
}

- (void)locationManager:(CLLocationManager *)manager
    didUpdateToLocation:(CLLocation *)newLocation
           fromLocation:(CLLocation *)oldLocation{
  
  if ([self isExecutingInBackground]){
    /* Aplikacja działa w tle. Nie należy przeprowadzać żadnych intensywnych operacji przetwarzania danych. */
  } else {
    /* Aplikacja jest aktywna. Można przeprowadzać dowolne operacje przetwarzania danych. */
  }
  
}

- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  self.myLocationManager = [[CLLocationManager alloc] init];
  self.myLocationManager.desiredAccuracy = kCLLocationAccuracyBest;
  self.myLocationManager.delegate = self;
  [self.myLocationManager startUpdatingLocation];
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationDidEnterBackground:(UIApplication *)application{
  self.executingInBackground = YES;
  
  /* Zmniejszenie dokładności podczas ustalania położenia urządzenia iOS, 
   gdy aplikacja zostanie przeniesiona do działania w tle. */
  self.myLocationManager.desiredAccuracy = kCLLocationAccuracyHundredMeters;
}

- (void)applicationWillEnterForeground:(UIApplication *)application{
  self.executingInBackground = NO;
  
  /* Kiedy aplikacja ponownie staje się aktywna, przywracamy wysoki poziom dokładności
   podczas ustalania położenia urządzenia iOS. */
  self.myLocationManager.desiredAccuracy = kCLLocationAccuracyBest;
}

@end
